//
//  HighPriorityButtonStyle.swift
//  Do It
//
//  Created by Jim Dovey on 1/28/20.
//  Copyright © 2020 Jim Dovey. All rights reserved.
//

import SwiftUI

struct HighPriorityButtonStyle: PrimitiveButtonStyle {
    func makeBody(configuration: PrimitiveButtonStyle.Configuration) -> some View {
        _Button(configuration: configuration)
    }

    private struct _Button: View {
        @State var pressed = false
        let configuration: PrimitiveButtonStyle.Configuration
        
        var body: some View {
            let gesture = DragGesture(minimumDistance: 0)
                .map { self.translation($0.translation, doesNotExceed: 15) }
                .onChanged { value in self.pressed = value }
                .onEnded { value in
                    guard self.pressed else { return }
                    self.pressed = false
                    self.configuration.trigger()
                }

            return configuration.label
                .opacity(pressed ? 0.5 : 1.0)
                .highPriorityGesture(gesture)
        }

        private func translation(_ translation: CGSize, doesNotExceed: CGFloat) -> Bool {
            let max = abs(doesNotExceed)
            return translation.width < max && translation.width > -max &&
                translation.height < max && translation.height > -max
        }
    }
}

struct HighPriorityButtonStyle_Previews: PreviewProvider {
    static var previews: some View {
        NavigationView {
            List {
                NavigationLink(destination: Text("Hello")) {
                    Button(action: { print("hello") }) {
                        Text("Button!")
                            .foregroundColor(.accentColor)
                    }
                    .buttonStyle(HighPriorityButtonStyle())
                }
            }
        }
    }
}
